﻿SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/****** Object:  Trigger [VX_TR_ReponseModifLog]    Script Date: 04/10/2013 10:52:08 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_ResponseModifLog_Insert]'))
DROP TRIGGER [dbo].[VX_TR_ResponseModifLog_Insert]
GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_ResponseModifLog_Update]'))
DROP TRIGGER [dbo].[VX_TR_ResponseModifLog_Update]
GO


IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_ResponseModifLog_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VX_TR_ResponseModifLog_Insert]
   ON  [dbo].[Response]
   AFTER INSERT
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;
  -- From the Installation configuration, the option for Audit of the Response table.
  DECLARE @AuditOn varchar(250)
  SET @AuditOn = (SELECT Installation.InsValue 
                  FROM Installation 
                  WHERE Installation.InsSection=''PROJECT'' and
                        Installation.InsIdent=''TRACK RESPONSE MODIFICATIONS'')
  SET @AuditOn = IsNull(@AuditOn, ''0'')
  -- If we want to bypass this depending on the source we may add  <or inserted.[Source]=''{sourceToUse}''>
  --   to this IF condition or vice versa to supress audit from a particular [Source]
  IF (@AuditOn = ''1'')
  BEGIN
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, NULL, 
             inserted.RpsOpened, NULL, inserted.[Source], isnull(inserted.modifiedby,''''), inserted.modified, inserted.CallId
      FROM inserted
  END
  ELSE IF (@AuditOn = ''2'')
  BEGIN
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, NULL, 
             inserted.RpsOpened, NULL, inserted.[Source], isnull(inserted.modifiedby,''''), inserted.modified, inserted.CallId
      FROM inserted
	  WHERE EXISTS (SELECT 1 FROM Installation WHERE INSSECTION = ''TRACKRESPONSE'' and INSIDENT LIKE ''QUESTION![%!]'' ESCAPE ''!'' and INSVALUE = inserted.RpsQuestion)
  END

END
' 
GO

IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_ResponseModifLog_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VX_TR_ResponseModifLog_Update]
   ON  [dbo].[Response]
   AFTER UPDATE
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;
  -- From the Installation configuration, the option for Audit of the Response table.
  DECLARE @AuditOn varchar(250)
  SET @AuditOn = (SELECT Installation.InsValue 
                  FROM Installation 
                  WHERE Installation.InsSection=''PROJECT'' and
                        Installation.InsIdent=''TRACK RESPONSE MODIFICATIONS'')
  SET @AuditOn = IsNull(@AuditOn, ''0'')
  -- If we want to bypass this depending on the source we may add  <or inserted.[Source]=''{sourceToUse}''>
  --   to this IF condition or vice versa to supress audit from a particular [Source]
  IF (@AuditOn = ''1'')
  BEGIN
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, deleted.RpsContent, 
             inserted.RpsOpened, deleted.RpsOpened, inserted.[Source], isnull(inserted.modifiedby,''''), inserted.modified, inserted.CallId
      FROM inserted left join deleted
      ON inserted.RpsRespondent = deleted.RpsRespondent and 
         inserted.RpsQuestion = deleted.RpsQuestion and 
         inserted.RpsMatrix = deleted.RpsMatrix and 
         inserted.RpsMention = deleted.RpsMention and 
         inserted.RpsType = deleted.RpsType
      WHERE ( inserted.RpsContent<>isnull(deleted.RpsContent,'''') ) or (inserted.RpsOpened <> isnull(deleted.RpsOpened,'''') )
  END
  ELSE IF (@AuditOn = ''2'')
  BEGIN
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, deleted.RpsContent, 
             inserted.RpsOpened, deleted.RpsOpened, inserted.[Source], isnull(inserted.modifiedby,''''), inserted.modified, inserted.CallId
      FROM inserted left join deleted
      ON inserted.RpsRespondent = deleted.RpsRespondent and 
         inserted.RpsQuestion = deleted.RpsQuestion and 
         inserted.RpsMatrix = deleted.RpsMatrix and 
         inserted.RpsMention = deleted.RpsMention and 
         inserted.RpsType = deleted.RpsType
      WHERE ((inserted.RpsContent<>isnull(deleted.RpsContent,'''')) or (inserted.RpsOpened <> isnull(deleted.RpsOpened,'''')))
	    and EXISTS (SELECT 1 FROM Installation WHERE INSSECTION = ''TRACKRESPONSE'' and INSIDENT LIKE ''QUESTION![%!]'' ESCAPE ''!'' and INSVALUE = inserted.RpsQuestion)
  END
END' 
GO
